/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParsingException;

public class StreamingNodeLister
extends NodeFactory {
    private Nodes empty = new Nodes();
    private int depth = 0;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.StreamingNodeLister URL");
            return;
        }
        Builder builder = new Builder((NodeFactory)new StreamingNodeLister());
        try {
            builder.build(stringArray[0]);
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public Nodes makeComment(String string) {
        this.printSpaces();
        System.out.println("Comment");
        return this.empty;
    }

    public Nodes makeText(String string) {
        this.printSpaces();
        System.out.println("Text");
        return this.empty;
    }

    public Element startMakingElement(String string, String string2) {
        ++this.depth;
        this.printSpaces();
        System.out.println("Element: " + string);
        return super.startMakingElement(string, string2);
    }

    public Nodes finishMakingElement(Element element) {
        --this.depth;
        return new Nodes((Node)element);
    }

    public Nodes makeDocType(String string, String string2, String string3) {
        System.out.println("DOCTYPE");
        return this.empty;
    }

    public Nodes makeProcessingInstruction(String string, String string2) {
        this.printSpaces();
        System.out.println("Processing instruction: " + string);
        return this.empty;
    }

    private void printSpaces() {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(' ');
        }
    }
}

